#include <POF/Gradient_estimator_RB.h>

extern double ccon_gradient[n_label][MAX_n_class][MAX_batch_size];
extern double test_case_ccon_gradient[n_label][MAX_n_class][MAX_n_internal_test_case];
extern double ccon_gradient_square[n_label][MAX_n_class][MAX_batch_size];
extern double test_case_ccon_gradient_square[n_label][MAX_n_class][MAX_n_internal_test_case];

extern void flatten_ccon_gradient(int n_label, int batch_size, int n_class, double ccon_gradient_list[]);
extern void flatten_test_case_ccon_gradient(int n_label, int n_internal_test_case, int n_class, double test_case_ccon_gradient_list[]);

extern void flatten_ccon_gradient_square(int n_label, int batch_size, int n_class, double ccon_gradient_square_list[]);
extern void flatten_test_case_ccon_gradient_square(int n_label, int batch_size, int n_class, double test_case_ccon_gradient_square_list[]);

extern std::default_random_engine generator;

extern void exp_map(double arr[], int len, double out[]);
extern double sum_arr(double arr[], int len);
extern void div_map(double arr[], int len, double divider, double out[]);

void RB_estimate_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double ccon_gradient_square_list[], int n_sample, int m_sample) {
	// // Set sample case gradient as zero.
	// for (int pm = 0; pm < n_label; pm++) {
	// 	for (int i = 0; i < nn_data->n_class; i++) ccon_gradient[pm][i] = 0;
	// }

    memset(ccon_gradient, 0, sizeof(ccon_gradient));
	memset(ccon_gradient_square, 0, sizeof(ccon_gradient_square));

    NN_data *new_nn_data(new NN_data);
    *new_nn_data = *nn_data;

    int new_normalclass[n_label][MAX_batch_size] {};

    const int len = nn_data->n_class;

	for (int pm = 0; pm < n_label; pm++) {
		memcpy(new_normalclass, nn_data->normalclass, sizeof(nn_data->normalclass));
        for (int j = 0; j < nn_data->batch_size; j++) {
	        double exp_ccon_w[MAX_n_class] {}, expsum, softmax[MAX_n_class] {};

            exp_map(nn_data->ccon_w[pm][j], len, exp_ccon_w);
	        expsum = sum_arr(exp_ccon_w, len);
	        div_map(exp_ccon_w, len, expsum, softmax);
	        std::discrete_distribution<int> output_distribution (softmax, softmax + len);

            for (int _ = 0; _ < n_sample; _++) { 
	            int output_sample = output_distribution(generator);
			    new_normalclass[pm][j] = output_sample;

                for (int _ = 0; _ < m_sample; _++) {
                    memcpy(new_nn_data->normalclass, new_normalclass, sizeof(new_normalclass));
                    for (int l = 0; l < nn_data->batch_size; l++) {
						if (l == j) continue;
                        double exp_ccon_w[MAX_n_class] {}, expsum, softmax[MAX_n_class] {};

                        exp_map(nn_data->ccon_w[pm][l], len, exp_ccon_w);
	                    expsum = sum_arr(exp_ccon_w, len);
	                    div_map(exp_ccon_w, len, expsum, softmax);
	                    std::discrete_distribution<int> output_distribution (softmax, softmax + len);

                        int output_sample = output_distribution(generator);
			            new_nn_data->normalclass[pm][l] = output_sample;
                    }
                    double approxloss_sample = calc_approx_loss(new_nn_data, indata, user_parameter);
                
                    for (int i = 0; i < nn_data->n_class; i++) {
                        double grad = 0;
	                    if (i == output_sample)
	                        grad += approxloss_sample; // * softmax[i] / softmax[i];
				        grad += - approxloss_sample * softmax[i]; // * softmax[output_sample] * softmax[i] / softmax[output_sample];
                        ccon_gradient[pm][i][j] += grad / (n_sample * m_sample);
						ccon_gradient_square[pm][i][j] += pow(grad, 2) / (n_sample * m_sample);
                    }
                }
            }
        }
	}

    delete new_nn_data;

	flatten_ccon_gradient(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_list);
	flatten_ccon_gradient_square(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_square_list);
}

void RB_estimate_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[], double test_case_ccon_gradient_square_list[], int n_sample, int m_sample) {
	memset(test_case_ccon_gradient, 0., sizeof(test_case_ccon_gradient));
	memset(test_case_ccon_gradient_square, 0., sizeof(test_case_ccon_gradient_square));

	double xi = user_parameter->xi;
	int n_rank = user_parameter->n_rank;
	int n_internal_test_case = nn_data->n_internal_test_case;
	int n_class = nn_data->n_class;

	Indata *new_indata(new Indata);
	Indata *newnew_indata(new Indata);
	// KKY to KSW!: definition. (start)
	
	// KKY to KSW!: (end)
	for (int pm = 0; pm < n_label; pm++) {
		*new_indata = *indata;
		for (int j = 0; j < n_internal_test_case; j++) {
			double expsum = 0;
			for (int k = 0; k < n_class; k++) expsum += exp(nn_data->test_case_ccon_w[pm][k][j]);
			for (int _ = 0; _ < n_sample; _++) {
				// KKY to KSW!: change the initialization code to avoid resetting normt of all neural network. (start)
			

				
				memset(new_indata->normaltable[pm], 0, sizeof(new_indata->normaltable[pm]));
				memset(new_indata->normaltable_eff[pm], 0, sizeof(new_indata->normaltable_eff[pm]));
				// KKY to KSW!: (end)
				for (int i = 0; i < n_class; i++) {
					double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][j] - xi) - exp(nn_data->test_case_ccon_w[pm][i][j]);
					double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][j] + xi) - exp(nn_data->test_case_ccon_w[pm][i][j]);
					std::discrete_distribution<int> indicator_distribution \
					{exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum + 1e-9, exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum + 1e-9, 1 - exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum + 1e-9};
					int indicator_pair = indicator_distribution(generator);
					if (indicator_pair == 0) {
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++;
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][0]++;
						new_indata->normaltable_eff[pm][i][j][1] = 1;
						new_indata->normaltable_eff[pm][i][j][0] = 1;
					}
					else if (indicator_pair == 1) {
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++; // KKY to KSW!: fix indexing problem (nn_data->nn_data->ans)
						new_indata->normaltable_eff[pm][i][j][1] = 1;
					}
				}

				for (int _ = 0; _ < m_sample; _++) {
					*newnew_indata = *new_indata;
					for (int l = 0; l < n_internal_test_case; l++) {
						if (l == j) continue;
						double expsum = 0;
						for (int k = 0; k < n_class; k++) expsum += exp(nn_data->test_case_ccon_w[pm][k][l]);
						for (int i = 0; i < n_class; i++) {
							double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][l] - xi) - exp(nn_data->test_case_ccon_w[pm][i][l]);
							double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][l] + xi) - exp(nn_data->test_case_ccon_w[pm][i][l]);
							std::discrete_distribution<int> indicator_distribution \
							{exp(nn_data->test_case_ccon_w[pm][i][l] - xi) / mxi_expsum + 1e-9, exp(nn_data->test_case_ccon_w[pm][i][l] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][i][l] - xi) / mxi_expsum + 1e-9, 1 - exp(nn_data->test_case_ccon_w[pm][i][l] + xi) / pxi_expsum + 1e-9};
							int indicator_pair = indicator_distribution(generator);
							if (indicator_pair == 0) {
								newnew_indata->normaltable[pm][nn_data->ans[pm][l]][i][1]++;
								newnew_indata->normaltable[pm][nn_data->ans[pm][l]][i][0]++;
								newnew_indata->normaltable_eff[pm][i][l][1] = 1;
								newnew_indata->normaltable_eff[pm][i][l][0] = 1;
							}
							else if (indicator_pair == 1) {
								newnew_indata->normaltable[pm][nn_data->ans[pm][l]][i][1]++;
								newnew_indata->normaltable_eff[pm][i][l][1] = 1;
							}
						}
					}
					set_posterior(nn_data, user_parameter, newnew_indata);
					double approxloss_sample = calc_approx_loss(nn_data, newnew_indata, user_parameter);
					for (int i = 0; i < n_class; i++) {
						double grad = 0;
						for (int k = 0; k < n_class; k++) {
							//calculate expsum for +-xi
							double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] - xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
							double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] + xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
							
							if (newnew_indata->normaltable_eff[pm][k][j][1] == 1 && newnew_indata->normaltable_eff[pm][k][j][0] == 1) {
								//(1,1) approxloss_sample * log(softmax(-xi))
								if (k == i) {
									grad += approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum);
								}
								else {
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum;
								}
							}
							else if (newnew_indata->normaltable_eff[pm][k][j][1]) {
								//(0,1) approxlos_sample * log(softmax(+xi)-softmax(-xi))
								if (k == i) {
									//org
									// test_case_ccon_gradient[pm][i][j] += approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
									// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
									// test_case_ccon_gradient[pm][i][j] /= exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
									//new
									grad += approxloss_sample;
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
								}
								else {
									//org
									// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
									// test_case_ccon_gradient[pm][i][j] += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum / mxi_expsum;
									// test_case_ccon_gradient[pm][i][j] /= exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
									//new
									grad += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / (expsum - exp(nn_data->test_case_ccon_w[pm][k][j]));
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum;
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum;
								}
							}
							else {
								//(0,0) approxloss_sample * log(1-softmax(+xi))
								if (k == i) {
									//org
									// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
									// test_case_ccon_gradient[pm][i][j] /= (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum);
									//new
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
								}
								else {
									//org
									// test_case_ccon_gradient[pm][i][j] += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
									// test_case_ccon_gradient[pm][i][j] /= (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum);
									//new
									grad += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / (expsum - exp(nn_data->test_case_ccon_w[pm][k][j]));
									grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum;
								}
							}
						}
						test_case_ccon_gradient[pm][i][j] += grad / (n_sample * m_sample); // KKY to KSW!: add parentheses
						test_case_ccon_gradient_square[pm][i][j] += pow(grad, 2) / (n_sample * m_sample);
					}
				}
			}
		}
	}

	delete new_indata;

	flatten_test_case_ccon_gradient(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_list);
	flatten_test_case_ccon_gradient_square(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_square_list);
}